<?php
include '../includes/db.php';
if (!isset($_GET['id'])) die('ID tempahan tidak sah');
$id = (int)$_GET['id'];
$order = $conn->query("SELECT * FROM orders WHERE id=$id")->fetch_assoc();
if (!$order) die('Tempahan tidak dijumpai');
$shop = $conn->query("SELECT * FROM shop_info WHERE id=1")->fetch_assoc();
$prices = [];
$res = $conn->query("SELECT * FROM prices");
while ($row = $res->fetch_assoc()) {
    $prices[$row['item_type']] = $row;
}
function item_row($bil, $label, $qty, $price) {
    $total = $qty * $price;
    return "<tr><td>$bil</td><td>$label</td><td>$qty</td><td>RM ".number_format($price,2)."</td><td>RM ".number_format($total,2)."</td></tr>";
}
?>
<!DOCTYPE html>
<html lang="ms">
<head>
    <meta charset="UTF-8">
    <title>Invoice #<?= $order['id'] ?></title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <style>
        body { background: #f8f9fa; }
        .invoice-box {
            background: #fff;
            padding: 32px 40px;
            border-radius: 12px;
            box-shadow: 0 2px 16px rgba(0,0,0,0.07);
            margin: 40px auto;
            max-width: 700px;
        }
        
        /* Print styles for A4 */
        @media print {
            @page {
                size: A4;
                margin: 15mm;
            }
            
            body {
                background: white !important;
                margin: 0;
                padding: 0;
            }
            
            .invoice-box {
                box-shadow: none;
                border: none;
                margin: 0;
                padding: 0;
                max-width: none;
                border-radius: 0;
            }
            
            .no-print {
                display: none !important;
            }
        }
        .invoice-header { border-bottom: 2px solid #eee; margin-bottom: 24px; padding-bottom: 16px; }
        .invoice-title { font-size: 1.5rem; font-weight: 700; }
        .invoice-no { font-size: 1.1rem; color: #888; text-align: right; }
        .bank-box { background: #f1f3f6; border-radius: 8px; padding: 12px 18px; margin-top: 18px; }
        .signature-box { 
            margin-top: 48px; 
            text-align: right; 
            display: flex;
            flex-direction: column;
            align-items: flex-end;
        }
        .signature-img { 
            max-width: 180px; 
            display: block; 
            margin-bottom: -5px; 
        }
        
        .stamp-box {
            margin-top: 48px;
            text-align: left;
        }
        
        .stamp-img {
            max-width: 120px;
            display: block;
        }
        
        /* Table styling */
        .table th { 
            background: #343a40 !important; 
            color: white !important;
            border-top: none; 
            font-weight: 600; 
        }
        
        .table-dark th {
            background: #212529 !important;
            color: white !important;
        }
        
        .table-light th {
            background: #6c757d !important;
            color: white !important;
        }
        
        /* Text alignment for specific columns */
        .table th:nth-child(3),
        .table th:nth-child(4),
        .table th:nth-child(5),
        .table td:nth-child(3),
        .table td:nth-child(4),
        .table td:nth-child(5),
        .table-dark th:nth-child(5),
        .table-dark th:last-child {
            text-align: right !important;
        }
    </style>
</head>
<body>
<div class="invoice-box">
    <div class="row invoice-header align-items-center">
        <div class="col-2">
            <?php if ($shop['logo_image']): ?>
                <img src="../uploads/<?= htmlspecialchars($shop['logo_image']) ?>" alt="Logo" style="max-width:180px;">
            <?php endif; ?>
        </div>
        <div class="col-8 text-center">
            <div class="invoice-title mb-1"><?= htmlspecialchars($shop['shop_name']) ?></div>
            <div style="font-size: 0.9rem; margin-bottom: 2px;"><?= nl2br(htmlspecialchars($shop['shop_address'])) ?></div>
            <div style="font-size: 0.9rem; margin-bottom: 0;">No Tel: <?= htmlspecialchars($shop['shop_phone']) ?></div>
        </div>
        <div class="col-2 invoice-no">
            <strong>INVOICE #<?= $order['id'] ?></strong>
        </div>
    </div>
    <div class="row mb-3">
                        <div class="col-6">
                    <strong>Nama:</strong> <?= htmlspecialchars($order['customer_name']) ?><br>
                    <strong>No Tel:</strong> <?= htmlspecialchars($order['customer_phone']) ?><br>
                    <strong>Alamat:</strong> <?= nl2br(htmlspecialchars($order['customer_address'])) ?>
                    <?php if ($order['perkara']): ?>
                        <br><strong>Perkara:</strong> <?= nl2br(htmlspecialchars($order['perkara'])) ?>
                    <?php endif; ?>
                </div>
        <div class="col-6 text-end">
            <strong>Tarikh Order:</strong> <?= $order['order_date'] ?>
        </div>
    </div>
    <table class="table table-bordered align-middle mb-4">
        <thead class="table-dark"><tr><th>BIL</th><th>Jenis</th><th>Kuantiti</th><th>Harga Seunit</th><th>Jumlah</th></tr></thead>
        <tbody>
            <?php 
            $bil = 1;
            if ($order['collar_ss'] > 0) {
                echo item_row($bil++, 'Kolar SS', $order['collar_ss'], $prices['collar_ss']['sale_price']);
            }
            if ($order['collar_ls'] > 0) {
                echo item_row($bil++, 'Kolar LS', $order['collar_ls'], $prices['collar_ls']['sale_price']);
            }
            if ($order['rn_ss'] > 0) {
                echo item_row($bil++, 'RN SS', $order['rn_ss'], $prices['rn_ss']['sale_price']);
            }
            if ($order['rn_ls'] > 0) {
                echo item_row($bil++, 'RN LS', $order['rn_ls'], $prices['rn_ls']['sale_price']);
            }
            if ($order['muslimah'] > 0) {
                echo item_row($bil++, 'Muslimah', $order['muslimah'], $prices['muslimah']['sale_price']);
            }
            ?>
            <tr><td><?= $bil ?></td><td>Kos Pos</td><td>-</td><td>-</td><td>RM <?= number_format($order['shipping_cost'],2) ?></td></tr>
            <tr class="table-dark"><th colspan="4">Jumlah Keseluruhan</th><th>RM <?= number_format($order['total_cost'],2) ?></th></tr>
        </tbody>
    </table>
    <div class="bank-box">
        <strong>Pembayaran boleh dibuat ke:</strong><br>
        <?= htmlspecialchars($shop['bank_name']) ?> (<?= htmlspecialchars($shop['bank_account']) ?>)<br>
        <strong>Nama Pemilik:</strong> <?= htmlspecialchars($shop['bank_owner']) ?>
    </div>
    <div class="row">
        <div class="col-6">
            <div class="stamp-box">
                <?php if ($shop['stamp_image']): ?>
                    <img src="../uploads/<?= htmlspecialchars($shop['stamp_image']) ?>" class="stamp-img" alt="Cop">
                <?php endif; ?>
            </div>
        </div>
        <div class="col-6">
            <div class="signature-box">
                <?php if ($shop['sign_image']): ?>
                    <img src="../uploads/<?= htmlspecialchars($shop['sign_image']) ?>" class="signature-img" alt="Tandatangan">
                <?php endif; ?>
                <div><strong><?= htmlspecialchars($shop['manager_name']) ?></strong></div>
            </div>
        </div>
    </div>

</div>

<script>
// Auto print when page loads
window.onload = function() {
    window.print();
};
</script>
</body>
</html> 