<?php
// Process form submission BEFORE any output
if (isset($_POST['submit'])) {
    // Start session and connect to database
    session_start();
    include 'includes/db.php';
    
    $customer_id = !empty($_POST['customer_id']) ? (int)$_POST['customer_id'] : null;
    $customer_name = trim($_POST['customer_name']);
    $customer_phone = trim($_POST['customer_phone']);
    $customer_address = trim($_POST['customer_address']);
    $perkara = trim($_POST['perkara']);
    $order_date = $_POST['order_date'];
    $due_date = !empty($_POST['due_date']) ? $_POST['due_date'] : null;
    $collar_ss = (int)$_POST['collar_ss'];
    $collar_ls = (int)$_POST['collar_ls'];
    $rn_ss = (int)$_POST['rn_ss'];
    $rn_ls = (int)$_POST['rn_ls'];
    $muslimah = (int)$_POST['muslimah'];
    $nama_nombor = (int)$_POST['nama_nombor'];
    $kain_diamond = (int)$_POST['kain_diamond'];
    $shipping_cost = (float)$_POST['shipping_cost'];
    $discount = (float)$_POST['discount'];
    
    // Get prices
    $prices = [];
    $price_result = $conn->query("SELECT * FROM prices");
    while ($row = $price_result->fetch_assoc()) {
        $prices[$row['item_type']] = $row;
    }
    
    // Calculate totals
    $total_cost = ($collar_ss * $prices['collar_ss']['purchase_price']) + 
                  ($collar_ls * $prices['collar_ls']['purchase_price']) + 
                  ($rn_ss * $prices['rn_ss']['purchase_price']) + 
                  ($rn_ls * $prices['rn_ls']['purchase_price']) + 
                  ($muslimah * $prices['muslimah']['purchase_price']) +
                  ($nama_nombor * $prices['nama_nombor']['purchase_price']) +
                  ($kain_diamond * $prices['kain_diamond']['purchase_price']) +
                  $shipping_cost;
    
    $total_cost_price = $total_cost;
    
    $total_sale = ($collar_ss * $prices['collar_ss']['sale_price']) + 
                  ($collar_ls * $prices['collar_ls']['sale_price']) + 
                  ($rn_ss * $prices['rn_ss']['sale_price']) + 
                  ($rn_ls * $prices['rn_ls']['sale_price']) + 
                  ($muslimah * $prices['muslimah']['sale_price']) +
                  ($nama_nombor * $prices['nama_nombor']['sale_price']) +
                  ($kain_diamond * $prices['kain_diamond']['sale_price']) +
                  $shipping_cost - $discount;
    
    $user_id = $_SESSION['user_id'];
    
    try {
        $stmt = $conn->prepare("INSERT INTO orders (user_id, customer_id, customer_name, customer_phone, customer_address, perkara, order_date, due_date, collar_ss, collar_ls, rn_ss, rn_ls, muslimah, nama_nombor, kain_diamond, shipping_cost, discount, total_cost, total_cost_price, total_sale) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        
        if (!$stmt) {
            throw new Exception("Prepare failed: " . $conn->error);
        }
        
        $stmt->bind_param('iissssssiiiiiiiddddd',
            $user_id, $customer_id, $customer_name, $customer_phone, $customer_address, $perkara, $order_date, $due_date,
            $collar_ss, $collar_ls, $rn_ss, $rn_ls, $muslimah, $nama_nombor, $kain_diamond,
            $shipping_cost, $discount, $total_cost, $total_cost_price, $total_sale
        );
        
        if (!$stmt->execute()) {
            throw new Exception("Execute failed: " . $stmt->error);
        }
        
        $stmt->close();
        
        // Update customer statistics if customer_id is provided
        if ($customer_id) {
            $stmt = $conn->prepare("UPDATE customers SET total_orders = total_orders + 1, total_spent = total_spent + ? WHERE id = ?");
            $stmt->bind_param('di', $total_sale, $customer_id);
    $stmt->execute();
    $stmt->close();
        }
        
        // Success - redirect
        header('Location: index.php?success=1');
    exit;
        
    } catch (Exception $e) {
        // Log error
        error_log("Error in tempahan.php: " . $e->getMessage());
        
        // Show error message instead of blank page
        $error_message = "Error: " . $e->getMessage();
    }
}

// Set page variables for header
$page_title = 'Tambah Tempahan';
$page_subtitle = 'Tambah Tempahan';
$current_page = 'add_order';
$base_path = '';

// Include header (includes session_start, db connection, and shop info)
include 'includes/header.php';
?>

    <style>
/* Product quantities layout improvements */
.product-label {
    font-size: 0.85rem;
    font-weight: 600;
    color: #495057;
    margin-bottom: 0.5rem;
    text-align: center;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}

.product-input {
    text-align: center;
    font-weight: 500;
    border: 2px solid #e9ecef;
    border-radius: 6px;
    padding: 0.5rem;
    transition: all 0.2s ease;
}

.product-input:focus {
    border-color: #007bff;
    box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25);
}

.product-input:hover {
    border-color: #adb5bd;
}
        
/* Responsive adjustments */
        @media (max-width: 767.98px) {
    .product-label {
        font-size: 0.75rem;
        margin-bottom: 0.25rem;
    }
    
    .product-input {
        padding: 0.375rem;
        font-size: 0.875rem;
        height: 38px;
            }
            
    .row.mb-3 > div {
        margin-bottom: 0.5rem;
            }
}

@media (max-width: 575.98px) {
    .product-label {
        font-size: 0.7rem;
    }
    
    .product-input {
        font-size: 0.8rem;
        padding: 0.25rem;
        height: 35px;
            }
        }
        
/* Ensure consistent spacing */
.row.mb-3 > div {
    margin-bottom: 1rem;
}

/* Better alignment for longer labels */
.col-md-2 .product-label {
    font-size: 0.8rem;
        }
        
/* Remove margin bottom on larger screens */
@media (min-width: 768px) {
    .row.mb-3 > div {
        margin-bottom: 0;
            }
        }
    </style>



<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2"><i class="bi bi-plus-circle"></i> Tambah Tempahan Baru</h1>
    <a href="index.php" class="btn btn-secondary btn-modern">
        <i class="bi bi-arrow-left"></i> Kembali ke Senarai
    </a>
        </div>

            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0"><i class="bi bi-plus-circle"></i> Tambah Tempahan Baru</h5>
                </div>
                <div class="card-body">
        <?php if (isset($error_message)): ?>
            <div class="alert alert-danger">
                <i class="bi bi-exclamation-triangle"></i> <?= htmlspecialchars($error_message) ?>
            </div>
        <?php endif; ?>
                    <form method="post">
            <input type="hidden" name="customer_id" id="customer_id">
            
            <!-- Customer Search Section -->
            <div class="card mb-3">
                <div class="card-header bg-light">
                    <h6 class="mb-0"><i class="bi bi-search"></i> Cari Pelanggan Sedia Ada</h6>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <label class="form-label">Cari dengan Nama atau No Tel</label>
                            <input type="text" id="customer_search" class="form-control" placeholder="Taip nama atau no tel untuk mencari...">
                            <div id="search_results" class="mt-2"></div>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Atau</label>
                            <button type="button" class="btn btn-outline-primary d-block" data-bs-toggle="modal" data-bs-target="#addCustomerModal">
                                <i class="bi bi-plus-circle"></i> Tambah Pelanggan Baru
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label">Nama Pelanggan</label>
                    <input type="text" name="customer_name" id="customer_name" class="form-control" required>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">No Tel</label>
                    <input type="text" name="customer_phone" id="customer_phone" class="form-control" required>
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Alamat Pelanggan</label>
                <textarea name="customer_address" id="customer_address" class="form-control" rows="3" required></textarea>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Perkara</label>
                            <textarea name="perkara" class="form-control" rows="3" placeholder="Masukkan perkara atau butiran tempahan..."></textarea>
                        </div>
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label">Tarikh Order</label>
                                <input type="date" name="order_date" class="form-control" value="<?= date('Y-m-d') ?>" required>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Tarikh Siap</label>
                                <input type="date" name="due_date" class="form-control">
                            </div>
                        </div>
                        <div class="row mb-3">
                <div class="col-6 col-md-1 mb-2">
                    <label class="form-label product-label">Kolar SS</label>
                    <input type="number" name="collar_ss" class="form-control product-input" min="0" value="0">
                </div>
                <div class="col-6 col-md-1 mb-2">
                    <label class="form-label product-label">Kolar LS</label>
                    <input type="number" name="collar_ls" class="form-control product-input" min="0" value="0">
                </div>
                <div class="col-6 col-md-1 mb-2">
                    <label class="form-label product-label">RN SS</label>
                    <input type="number" name="rn_ss" class="form-control product-input" min="0" value="0">
                </div>
                <div class="col-6 col-md-1 mb-2">
                    <label class="form-label product-label">RN LS</label>
                    <input type="number" name="rn_ls" class="form-control product-input" min="0" value="0">
                            </div>
                <div class="col-6 col-md-1 mb-2">
                    <label class="form-label product-label">Muslimah</label>
                    <input type="number" name="muslimah" class="form-control product-input" min="0" value="0">
                            </div>
                <div class="col-6 col-md-2 mb-2">
                    <label class="form-label product-label">Nama/Nombor</label>
                    <input type="number" name="nama_nombor" class="form-control product-input" min="0" value="0">
                            </div>
                <div class="col-6 col-md-2 mb-2">
                    <label class="form-label product-label">Kain Diamond</label>
                    <input type="number" name="kain_diamond" class="form-control product-input" min="0" value="0">
                            </div>
                <div class="col-6 col-md-2 mb-2">
                    <label class="form-label product-label">Kos Pos (RM)</label>
                    <input type="number" step="0.01" name="shipping_cost" class="form-control product-input" min="0" value="0">
                            </div>
                <div class="col-6 col-md-2 mb-2">
                    <label class="form-label product-label">Diskaun (RM)</label>
                    <input type="number" step="0.01" name="discount" class="form-control product-input" min="0" value="0">
                            </div>
                        </div>
                        <div class="text-end">
                            <button type="submit" name="submit" class="btn btn-primary btn-modern">
                                <i class="bi bi-plus-circle"></i> Tambah Tempahan
                            </button>
                        </div>
                    </form>
                </div>
</div>

<!-- Modal Tambah Pelanggan Baru -->
<div class="modal fade" id="addCustomerModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Tambah Pelanggan Baru</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <form id="addCustomerForm">
                    <div class="mb-3">
                        <label class="form-label">Nama Pelanggan</label>
                        <input type="text" id="new_customer_name" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">No Tel</label>
                        <input type="text" id="new_customer_phone" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Alamat</label>
                        <textarea id="new_customer_address" class="form-control" rows="3" required></textarea>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                <button type="button" class="btn btn-primary" onclick="addNewCustomer()">Tambah Pelanggan</button>
            </div>
        </div>
    </div>
</div>

<script>
    // Debug function for development
    function updateDebugInfo(message) {
        console.log(message);
    }

    function searchCustomers() {
        const searchTerm = document.getElementById('customer_search').value.trim();
        
        if (searchTerm.length < 2) {
            clearSearchResults();
            return;
        }
        
        console.log('Searching for:', searchTerm);
        console.log('API URL:', 'api/search_customers.php');
        
        fetch('api/search_customers.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded',
            },
            body: 'search=' + encodeURIComponent(searchTerm)
        })
        .then(response => {
            console.log('API Response status:', response.status);
            return response.json();
        })
        .then(data => {
            console.log('Search results:', data);
            displaySearchResults(data);
        })
        .catch(error => {
            console.error('Error:', error);
            document.getElementById('search_results').innerHTML = '<div class="alert alert-danger">Error: ' + error.message + '</div>';
        });
    }

function displaySearchResults(customers) {
    const resultsDiv = document.getElementById('search_results');
    
    if (!customers || customers.length === 0) {
        resultsDiv.innerHTML = '<div class="alert alert-info">Tiada pelanggan dijumpai</div>';
        return;
    }
    
    let html = '<div class="list-group">';
    customers.forEach(customer => {
        console.log('Processing customer:', customer);
        
        html += `
            <button type="button" class="list-group-item list-group-item-action customer-select-btn" 
                    data-id="${customer.id}" 
                    data-name="${customer.name.replace(/"/g, '&quot;')}" 
                    data-phone="${customer.phone.replace(/"/g, '&quot;')}" 
                    data-address="${customer.address.replace(/"/g, '&quot;').replace(/\n/g, '\\n')}">
                <div class="d-flex justify-content-between align-items-start">
                    <div>
                        <strong>${customer.name}</strong><br>
                        <small class="text-muted">${customer.phone}</small><br>
                        <small class="text-muted">${customer.address}</small>
                    </div>
                    <div class="text-end">
                        <span class="badge bg-primary">${customer.order_count} order</span><br>
                        <small class="text-muted">RM ${parseFloat(customer.total_spent || 0).toFixed(2)}</small>
                    </div>
                </div>
            </button>
        `;
    });
    html += '</div>';
    
    resultsDiv.innerHTML = html;
    
                // Add click event listeners
            document.querySelectorAll('.customer-select-btn').forEach(btn => {
                btn.addEventListener('click', function() {
                    const id = this.getAttribute('data-id');
                    const name = this.getAttribute('data-name');
                    const phone = this.getAttribute('data-phone');
                    const address = this.getAttribute('data-address');
                    
                    selectCustomer(id, name, phone, address);
                });
            });
}

        function selectCustomer(id, name, phone, address) {
            console.log('selectCustomer called with:', { id, name, phone, address });
            
            // Convert id to number if it's a string
            const customerId = parseInt(id);
            
            // Get form elements
            const customerIdField = document.getElementById('customer_id');
            const customerNameField = document.getElementById('customer_name');
            const customerPhoneField = document.getElementById('customer_phone');
            const customerAddressField = document.getElementById('customer_address');
            
            // Check if elements exist
            if (!customerIdField || !customerNameField || !customerPhoneField || !customerAddressField) {
                console.error('Form elements not found');
                alert('Error: Form elements not found');
                return;
            }
            
            // Set values
            customerIdField.value = customerId;
            customerNameField.value = name;
            customerPhoneField.value = phone;
            // Clean up address - normalize all types of line breaks and remove extra whitespace
            const cleanAddress = address
                .replace(/\\n/g, '\n')  // Convert escaped newlines
                .replace(/\r\n/g, '\n') // Convert Windows line breaks
                .replace(/\r/g, '\n')   // Convert Mac line breaks
                .replace(/\n\s*\n/g, '\n') // Remove empty lines
                .replace(/^\s+|\s+$/g, ''); // Trim whitespace
            customerAddressField.value = cleanAddress;
            
            console.log('Form values set:', {
                customer_id: customerIdField.value,
                customer_name: customerNameField.value,
                customer_phone: customerPhoneField.value,
                customer_address: customerAddressField.value
            });
            
            // Clear search
            const searchField = document.getElementById('customer_search');
            if (searchField) {
                searchField.value = '';
            }
            clearSearchResults();
            
            // Show success message
            const resultsDiv = document.getElementById('search_results');
            if (resultsDiv) {
                resultsDiv.innerHTML = '<div class="alert alert-success">Pelanggan dipilih: ' + name + '</div>';
                
                // Auto-hide success message after 3 seconds
                setTimeout(() => {
                    clearSearchResults();
                }, 3000);
            }
        }

function clearCustomerSearch() {
    document.getElementById('customer_id').value = '';
    document.getElementById('customer_name').value = '';
    document.getElementById('customer_phone').value = '';
    document.getElementById('customer_address').value = '';
    document.getElementById('customer_search').value = '';
    clearSearchResults();
}

function clearSearchResults() {
    const resultsDiv = document.getElementById('search_results');
    resultsDiv.innerHTML = '';
}

// Add event listener for search input
document.addEventListener('DOMContentLoaded', function() {
    console.log('DOM loaded, setting up search listener...');
    const searchInput = document.getElementById('customer_search');
    if (searchInput) {
        console.log('Search input found, adding event listener...');
        searchInput.addEventListener('input', function() {
            const searchTerm = this.value.trim();
            console.log('Search input changed:', searchTerm);
            if (searchTerm.length >= 2) {
                console.log('Triggering search...');
                searchCustomers();
            } else {
                console.log('Clearing results...');
                clearSearchResults();
        }
    });
    } else {
        console.error('Search input not found!');
    }
});

// Test function for debugging
function testSelectCustomer() {
    console.log('Testing selectCustomer function...');
    
    // Test with sample data
    const testData = {
        id: 1,
        name: "MOHD AL HAFIZ BIN A AZIZ",
        phone: "0194373977",
        address: "NO 63 JALAN SERINDIT 29\nBANDAR SERI ALAM"
    };
    
    selectCustomer(testData.id, testData.name, testData.phone, testData.address);
}

// Add new customer functionality
function addNewCustomer() {
    const name = document.getElementById('new_customer_name').value.trim();
    const phone = document.getElementById('new_customer_phone').value.trim();
    const address = document.getElementById('new_customer_address').value.trim();
    
    if (!name || !phone || !address) {
        alert('Sila isi semua maklumat pelanggan');
        return;
    }
    
    // Show loading state
    const submitBtn = document.querySelector('#addCustomerModal .btn-primary');
    const originalText = submitBtn.innerHTML;
    submitBtn.innerHTML = '<i class="bi bi-hourglass-split"></i> Menambah...';
    submitBtn.disabled = true;
    
    fetch('api/add_customer.php', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
        },
        body: JSON.stringify({
            name: name,
            phone: phone,
            address: address
        })
    })
    .then(response => response.json())
    .then(data => {
        console.log('Add customer response:', data);
        
        if (data.success) {
            // Auto-fill the main form with customer ID
            document.getElementById('customer_id').value = data.customer_id || '';
            document.getElementById('customer_name').value = name;
            document.getElementById('customer_phone').value = phone;
            document.getElementById('customer_address').value = address;
            
            // Close modal
            const modal = bootstrap.Modal.getInstance(document.getElementById('addCustomerModal'));
            modal.hide();
            
            // Clear modal form
            document.getElementById('addCustomerForm').reset();
            
            // Show success message
            const resultsDiv = document.getElementById('search_results');
            if (resultsDiv) {
                resultsDiv.innerHTML = '<div class="alert alert-success">Pelanggan berjaya ditambah dan dipilih!</div>';
                
                // Auto-hide success message after 3 seconds
                setTimeout(() => {
                    clearSearchResults();
                }, 3000);
            }
        } else {
            alert('Error: ' + (data.message || 'Unknown error'));
    }
    })
    .catch(error => {
        console.error('Error:', error);
        alert('Error menambah pelanggan: ' + error.message);
    })
    .finally(() => {
        // Reset button state
        submitBtn.innerHTML = originalText;
        submitBtn.disabled = false;
    });
}
</script>

<?php include 'includes/footer.php'; ?> 