<?php
session_start();
include 'includes/db.php';

// Check if user is logged in
if (!isset($_SESSION['user_logged_in'])) {
    header('Location: login.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $invoice_id = (int)$_POST['invoice_id'];
    $customer_phone = $_POST['customer_phone'];
    
    // Generate unique token
    $token = bin2hex(random_bytes(32));
    
    // Check if link already exists for this invoice
    $check_query = "SELECT * FROM invoice_links WHERE invoice_id = ? AND is_active = 1";
    $stmt = $conn->prepare($check_query);
    $stmt->bind_param('i', $invoice_id);
    $stmt->execute();
    $existing = $stmt->get_result();
    
    if ($existing->num_rows > 0) {
        // Update existing link
        $update_query = "UPDATE invoice_links SET token = ?, created_at = CURRENT_TIMESTAMP, expires_at = (CURRENT_TIMESTAMP + INTERVAL 30 DAY) WHERE invoice_id = ?";
        $stmt = $conn->prepare($update_query);
        $stmt->bind_param('si', $token, $invoice_id);
    } else {
        // Create new link
        $insert_query = "INSERT INTO invoice_links (invoice_id, token, created_by) VALUES (?, ?, ?)";
        $stmt = $conn->prepare($insert_query);
        $stmt->bind_param('isi', $invoice_id, $token, $_SESSION['user_id']);
    }
    
    if ($stmt->execute()) {
        // Generate the public link
        $base_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]";
        $public_link = $base_url . dirname($_SERVER['REQUEST_URI']) . "/public_invoice.php?id=" . $invoice_id . "&token=" . $token;
        
        // Format phone number for WhatsApp (remove + and add country code if needed)
        $whatsapp_phone = preg_replace('/[^0-9]/', '', $customer_phone);
        if (substr($whatsapp_phone, 0, 1) === '0') {
            $whatsapp_phone = '60' . substr($whatsapp_phone, 1);
        }
        
        // Create WhatsApp message
        $message = "Assalamualaikum! Berikut adalah link invoice untuk tempahan anda:\n\n";
        $message .= $public_link . "\n\n";
        $message .= "Link ini sah selama 30 hari sahaja.\n";
        $message .= "Terima kasih!";
        
        // Create WhatsApp URL
        $whatsapp_url = "https://wa.me/" . $whatsapp_phone . "?text=" . urlencode($message);
        
        // Return success response
        $response = [
            'success' => true,
            'whatsapp_url' => $whatsapp_url,
            'public_link' => $public_link,
            'message' => 'Link invoice berjaya dijana!'
        ];
        
        echo json_encode($response);
        exit;
    } else {
        $response = [
            'success' => false,
            'message' => 'Gagal menjana link invoice.'
        ];
        
        echo json_encode($response);
        exit;
    }
}

// If not POST request, return error
$response = [
    'success' => false,
    'message' => 'Invalid request method.'
];

echo json_encode($response);
?> 