-- Struktur jadual tempahan baju
CREATE TABLE IF NOT EXISTS orders (
    id INT AUTO_INCREMENT PRIMARY KEY,
    customer_name VARCHAR(100) NOT NULL,
    customer_phone VARCHAR(30) NOT NULL,
    customer_address TEXT NOT NULL,
    order_date DATE NOT NULL,
    due_date DATE NULL,
    collar_ss INT DEFAULT 0,
    collar_ls INT DEFAULT 0,
    rn_ss INT DEFAULT 0,
    rn_ls INT DEFAULT 0,
    muslimah INT DEFAULT 0,
    nama_nombor INT DEFAULT 0,
    kain_diamond INT DEFAULT 0,
    shipping_cost DECIMAL(10,2) DEFAULT 0.00,
    total_cost DECIMAL(10,2) DEFAULT 0.00
);

-- Tambah kolum status_order, status_hantar, status_bayar pada orders
ALTER TABLE orders ADD COLUMN status_order ENUM('Baru','Dalam Proses','Siap','Batal') DEFAULT 'Baru' AFTER total_cost;
ALTER TABLE orders ADD COLUMN status_hantar ENUM('Belum','Sudah') DEFAULT 'Belum' AFTER status_order;
ALTER TABLE orders ADD COLUMN status_bayar ENUM('Belum','Sudah') DEFAULT 'Belum' AFTER status_hantar;

-- Tambah kolum total_cost_price dan total_sale pada orders
ALTER TABLE orders ADD COLUMN total_cost_price DECIMAL(10,2) DEFAULT 0.00 AFTER total_cost;
ALTER TABLE orders ADD COLUMN total_sale DECIMAL(10,2) DEFAULT 0.00 AFTER total_cost_price;

-- Tambah kolum perkara pada orders
ALTER TABLE orders ADD COLUMN perkara TEXT AFTER customer_address;

-- Tambah kolum nama_nombor dan kain_diamond pada orders (jika belum ada)
ALTER TABLE orders ADD COLUMN nama_nombor INT DEFAULT 0 AFTER muslimah;
ALTER TABLE orders ADD COLUMN kain_diamond INT DEFAULT 0 AFTER nama_nombor;

-- Jadual pelanggan
CREATE TABLE IF NOT EXISTS customers (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(100) NOT NULL,
    phone VARCHAR(30) UNIQUE NOT NULL,
    address TEXT NOT NULL,
    total_orders INT DEFAULT 0,
    total_spent DECIMAL(10,2) DEFAULT 0.00,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Tambah kolum customer_id pada orders untuk foreign key
ALTER TABLE orders ADD COLUMN customer_id INT NULL AFTER id;
ALTER TABLE orders ADD FOREIGN KEY (customer_id) REFERENCES customers(id) ON DELETE SET NULL;

-- Jadual harga jualan & belian
CREATE TABLE IF NOT EXISTS prices (
    id INT AUTO_INCREMENT PRIMARY KEY,
    item_type VARCHAR(50) NOT NULL,
    sale_price DECIMAL(10,2) NOT NULL,
    purchase_price DECIMAL(10,2) NOT NULL
);

-- Jadual maklumat kedai
CREATE TABLE IF NOT EXISTS shop_info (
    id INT PRIMARY KEY,
    shop_name VARCHAR(100) NOT NULL,
    shop_address TEXT NOT NULL,
    shop_phone VARCHAR(30) NOT NULL,
    manager_name VARCHAR(100) NOT NULL,
    stamp_image VARCHAR(255),
    logo_image VARCHAR(255)
);

-- Tambah kolum bank_name, bank_account, sign_image pada shop_info
ALTER TABLE shop_info ADD COLUMN bank_name VARCHAR(100) AFTER logo_image;
ALTER TABLE shop_info ADD COLUMN bank_account VARCHAR(100) AFTER bank_name;
ALTER TABLE shop_info ADD COLUMN sign_image VARCHAR(255) AFTER bank_account;

-- Tambah kolum bank_owner pada shop_info
ALTER TABLE shop_info ADD COLUMN bank_owner VARCHAR(100) AFTER bank_account;

-- Masukkan satu rekod default untuk shop_info
INSERT INTO shop_info (id, shop_name, shop_address, shop_phone, manager_name, stamp_image, logo_image)
VALUES (1, 'Nama Kedai', 'Alamat Kedai', 'No Tel Kedai', 'Nama Pengurus', '', '')
ON DUPLICATE KEY UPDATE id=id;

-- Masukkan harga default untuk setiap jenis baju
INSERT INTO prices (item_type, sale_price, purchase_price) VALUES
('collar_ss', 30.00, 20.00),
('collar_ls', 32.00, 22.00),
('rn_ss', 28.00, 18.00),
('rn_ls', 30.00, 20.00),
('muslimah', 35.00, 25.00),
('nama_nombor', 5.00, 3.00),
('kain_diamond', 15.00, 10.00)
ON DUPLICATE KEY UPDATE item_type=item_type; 

-- Jadual pengguna sistem
CREATE TABLE IF NOT EXISTS users (
    iduser INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(50) UNIQUE NOT NULL,
    password VARCHAR(255) NOT NULL,
    realname VARCHAR(100) NOT NULL,
    peranan ENUM('Admin', 'Pengurus', 'Pekerja') NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Masukkan pengguna default (Admin)
INSERT INTO users (username, password, realname, peranan) VALUES
('admin', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Administrator', 'Admin')
ON DUPLICATE KEY UPDATE username=username; 