<?php
// Cleanup script for expired invoice links
// This should be run via cron job daily

include 'includes/db.php';

// Deactivate expired links
$cleanup_query = "UPDATE invoice_links SET is_active = 0 WHERE expires_at < NOW()";
$result = $conn->query($cleanup_query);

if ($result) {
    $affected_rows = $conn->affected_rows;
    echo "Successfully deactivated $affected_rows expired invoice links.\n";
} else {
    echo "Error cleaning up expired links: " . $conn->error . "\n";
}

// Optional: Delete very old links (older than 60 days)
$delete_old_query = "DELETE FROM invoice_links WHERE created_at < DATE_SUB(NOW(), INTERVAL 60 DAY)";
$result = $conn->query($delete_old_query);

if ($result) {
    $affected_rows = $conn->affected_rows;
    echo "Successfully deleted $affected_rows old invoice links.\n";
} else {
    echo "Error deleting old links: " . $conn->error . "\n";
}

$conn->close();
?> 