<?php
header('Content-Type: application/json');
include '../includes/db.php';

// Handle both GET and POST requests
$search = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $search = isset($_POST['search']) ? trim($_POST['search']) : '';
} else {
    $search = isset($_GET['q']) ? trim($_GET['q']) : '';
}

if (empty($search)) {
    echo json_encode([]);
    exit;
}

// Search customers by phone or name
$stmt = $conn->prepare("
    SELECT c.id, c.name, c.phone, c.address, 
           COUNT(o.id) as order_count,
           SUM(o.total_sale) as total_spent
    FROM customers c
    LEFT JOIN orders o ON c.id = o.customer_id
    WHERE c.phone LIKE ? OR c.name LIKE ?
    GROUP BY c.id, c.name, c.phone, c.address
    ORDER BY c.name ASC
    LIMIT 10
");

$search_term = "%$search%";
$stmt->bind_param('ss', $search_term, $search_term);
$stmt->execute();
$result = $stmt->get_result();

$customers = [];
while ($row = $result->fetch_assoc()) {
    // Clean up address - normalize line breaks and remove extra whitespace
    $clean_address = $row['address'];
    $clean_address = str_replace(["\r\n", "\r"], "\n", $clean_address); // Normalize line breaks
    $clean_address = preg_replace('/\n\s*\n/', "\n", $clean_address); // Remove empty lines
    $clean_address = trim($clean_address); // Trim whitespace
    
    $customers[] = [
        'id' => $row['id'],
        'name' => $row['name'],
        'phone' => $row['phone'],
        'address' => $clean_address,
        'order_count' => $row['order_count'],
        'total_spent' => $row['total_spent']
    ];
}

$stmt->close();
echo json_encode($customers);
?> 