<?php
header('Content-Type: application/json');
include '../includes/db.php';

// Check if user is logged in
session_start();
if (!isset($_SESSION['user_logged_in'])) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);

$name = trim($input['name'] ?? '');
$phone = trim($input['phone'] ?? '');
$address = trim($input['address'] ?? '');

// Clean up address - normalize line breaks and remove extra whitespace
$address = str_replace(["\r\n", "\r"], "\n", $address); // Normalize line breaks
$address = preg_replace('/\n\s*\n/', "\n", $address); // Remove empty lines
$address = trim($address); // Trim whitespace

// Validation
if (empty($name) || empty($phone) || empty($address)) {
    http_response_code(400);
    echo json_encode(['error' => 'Sila isi semua maklumat pelanggan']);
    exit;
}

// Check if phone already exists
$stmt = $conn->prepare("SELECT id FROM customers WHERE phone = ?");
$stmt->bind_param('s', $phone);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    http_response_code(400);
    echo json_encode(['error' => 'No telefon sudah wujud dalam sistem']);
    $stmt->close();
    exit;
}
$stmt->close();

// Insert new customer
$stmt = $conn->prepare("INSERT INTO customers (name, phone, address) VALUES (?, ?, ?)");
$stmt->bind_param('sss', $name, $phone, $address);

if ($stmt->execute()) {
    $customer_id = $conn->insert_id;
    echo json_encode([
        'success' => true,
        'message' => 'Pelanggan berjaya ditambah',
        'customer_id' => $customer_id,
        'customer' => [
            'id' => $customer_id,
            'name' => $name,
            'phone' => $phone,
            'address' => $address
        ]
    ]);
} else {
    http_response_code(500);
    echo json_encode(['error' => 'Gagal menambah pelanggan']);
}

$stmt->close();
?> 