<?php
// Process form submissions BEFORE any output
if (isset($_POST['add_user'])) {
    // Start session and connect to database
    session_start();
    include '../includes/db.php';
    
    // Check if user is Admin
    if ($_SESSION['user_peranan'] !== 'Admin') {
        header('Location: ../index.php');
        exit;
    }
    
    $username = trim($_POST['username']);
    $realname = trim($_POST['realname']);
    $password = $_POST['password'];
    $peranan = $_POST['peranan'];
    
    try {
        // Check if username already exists
        $check_stmt = $conn->prepare("SELECT iduser FROM users WHERE username = ?");
        $check_stmt->bind_param('s', $username);
        $check_stmt->execute();
        $check_result = $check_stmt->get_result();
        
        if ($check_result->num_rows > 0) {
            throw new Exception("Username sudah wujud!");
        }
        
        $hashed_password = password_hash($password, PASSWORD_DEFAULT);
        $stmt = $conn->prepare("INSERT INTO users (username, realname, password, peranan) VALUES (?, ?, ?, ?)");
        $stmt->bind_param('ssss', $username, $realname, $hashed_password, $peranan);
        $stmt->execute();
        $stmt->close();
        
        // Success - redirect
        header('Location: users.php?success=1');
        exit;
        
    } catch (Exception $e) {
        // Log error
        error_log("Error in users.php add: " . $e->getMessage());
        
        // Show error message instead of blank page
        $error_message = $e->getMessage();
    }
}

if (isset($_POST['edit_user'])) {
    // Start session and connect to database
    session_start();
    include '../includes/db.php';
    
    // Check if user is Admin
    if ($_SESSION['user_peranan'] !== 'Admin') {
        header('Location: ../index.php');
        exit;
    }
    
    $user_id = (int)$_POST['user_id'];
    $realname = trim($_POST['realname']);
    $peranan = $_POST['peranan'];
    $password = $_POST['password'];
    
    try {
        if (!empty($password)) {
            $hashed_password = password_hash($password, PASSWORD_DEFAULT);
            $stmt = $conn->prepare("UPDATE users SET realname=?, peranan=?, password=? WHERE iduser=?");
            $stmt->bind_param('sssi', $realname, $peranan, $hashed_password, $user_id);
        } else {
            $stmt = $conn->prepare("UPDATE users SET realname=?, peranan=? WHERE iduser=?");
            $stmt->bind_param('ssi', $realname, $peranan, $user_id);
        }
        $stmt->execute();
        $stmt->close();
        
        // Success - redirect
        header('Location: users.php?updated=1');
        exit;
        
    } catch (Exception $e) {
        // Log error
        error_log("Error in users.php edit: " . $e->getMessage());
        
        // Show error message instead of blank page
        $error_message = $e->getMessage();
    }
}

if (isset($_POST['delete_user'])) {
    // Start session and connect to database
    session_start();
    include '../includes/db.php';
    
    // Check if user is Admin
    if ($_SESSION['user_peranan'] !== 'Admin') {
        header('Location: ../index.php');
        exit;
    }
    
    $user_id = (int)$_POST['user_id'];
    
    try {
        // Don't allow admin to delete themselves
        if ($user_id == $_SESSION['user_id']) {
            throw new Exception("Anda tidak boleh memadam akaun sendiri!");
        }
        
        $stmt = $conn->prepare("DELETE FROM users WHERE iduser=?");
        $stmt->bind_param('i', $user_id);
        $stmt->execute();
        $stmt->close();
        
        // Success - redirect
        header('Location: users.php?deleted=1');
        exit;
        
    } catch (Exception $e) {
        // Log error
        error_log("Error in users.php delete: " . $e->getMessage());
        
        // Show error message instead of blank page
        $error_message = $e->getMessage();
    }
}

// Set page variables for header
$page_title = 'Pengurusan Pengguna';
$page_subtitle = 'Pengurusan Pengguna';
$current_page = 'users';
$base_path = '';

// Include header (includes session_start, db connection, and shop info)
include '../includes/header.php';

// Check if user is Admin
if ($_SESSION['user_peranan'] !== 'Admin') {
    header('Location: ../index.php');
    exit;
}


// Get all users
$users = $conn->query("SELECT * FROM users ORDER BY iduser DESC");
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2"><i class="bi bi-person-gear"></i> Pengurusan Pengguna</h1>
    <button class="btn btn-primary btn-modern" data-bs-toggle="modal" data-bs-target="#addUserModal">
        <i class="bi bi-plus-circle"></i> Tambah Pengguna
    </button>
</div>

<?php if (isset($_GET['success'])): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="bi bi-check-circle"></i> Pengguna berjaya ditambah!
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<?php if (isset($_GET['updated'])): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="bi bi-check-circle"></i> Pengguna berjaya dikemaskini!
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<?php if (isset($error_message)): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="bi bi-exclamation-triangle"></i> <?= htmlspecialchars($error_message) ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<?php if (isset($_GET['deleted'])): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="bi bi-check-circle"></i> Pengguna berjaya dipadam!
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<?php if (isset($error)): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="bi bi-exclamation-triangle"></i> <?= $error ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<div class="card">
    <div class="card-header">
        <h5 class="mb-0"><i class="bi bi-people"></i> Senarai Pengguna</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead class="table-dark">
                    <tr>
                        <th>Bil</th>
                        <th>Username</th>
                        <th>Nama Sebenar</th>
                        <th>Peranan</th>
                        <th>Tarikh Dicipta</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $i = 1; while ($user = $users->fetch_assoc()): ?>
                    <tr>
                        <td><?= $i++ ?></td>
                        <td><?= htmlspecialchars($user['username']) ?></td>
                        <td><?= htmlspecialchars($user['realname']) ?></td>
                        <td>
                            <span class="badge bg-<?= $user['peranan'] === 'Admin' ? 'danger' : ($user['peranan'] === 'Pengurus' ? 'warning' : 'success') ?>">
                                <?= $user['peranan'] ?>
                            </span>
                        </td>
                        <td><?= date('d/m/Y H:i', strtotime($user['created_at'])) ?></td>
                        <td>
                            <div class="btn-group" role="group">
                                                        <button class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#editUserModal<?= $user['iduser'] ?>" title="Edit Pengguna">
                            <i class="bi bi-pencil"></i>
                        </button>
                        <?php if ($user['iduser'] != $_SESSION['user_id']): ?>
                        <button class="btn btn-sm btn-danger" data-bs-toggle="modal" data-bs-target="#deleteUserModal<?= $user['iduser'] ?>" title="Padam Pengguna">
                                    <i class="bi bi-trash"></i>
                                </button>
                                <?php endif; ?>
                            </div>
                        </td>
                    </tr>
                    
                    <!-- Modal Edit User -->
                    <div class="modal fade" id="editUserModal<?= $user['iduser'] ?>" tabindex="-1">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <form method="post">
                                <div class="modal-header">
                                    <h5 class="modal-title">Edit Pengguna</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                </div>
                                <div class="modal-body">
                                    <input type="hidden" name="user_id" value="<?= $user['iduser'] ?>">
                                    <div class="mb-3">
                                        <label class="form-label">Username</label>
                                        <input type="text" class="form-control" value="<?= htmlspecialchars($user['username']) ?>" readonly>
                                        <small class="text-muted">Username tidak boleh diubah</small>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label">Nama Sebenar</label>
                                        <input type="text" name="realname" class="form-control" value="<?= htmlspecialchars($user['realname']) ?>" required>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label">Peranan</label>
                                        <select name="peranan" class="form-select" required>
                                            <option value="Admin" <?= $user['peranan'] === 'Admin' ? 'selected' : '' ?>>Admin</option>
                                            <option value="Pengurus" <?= $user['peranan'] === 'Pengurus' ? 'selected' : '' ?>>Pengurus</option>
                                            <option value="Pekerja" <?= $user['peranan'] === 'Pekerja' ? 'selected' : '' ?>>Pekerja</option>
                                        </select>
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label">Password Baru</label>
                                        <input type="password" name="password" class="form-control" placeholder="Biar kosong jika tidak mahu ubah password">
                                        <small class="text-muted">Minimum 6 aksara</small>
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                                    <button type="submit" name="edit_user" class="btn btn-primary">Simpan Perubahan</button>
                                </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Modal Delete User -->
                    <?php if ($user['iduser'] != $_SESSION['user_id']): ?>
                    <div class="modal fade" id="deleteUserModal<?= $user['iduser'] ?>" tabindex="-1">
                        <div class="modal-dialog">
                            <div class="modal-content">
                                <form method="post">
                                <div class="modal-header">
                                    <h5 class="modal-title">Padam Pengguna</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                </div>
                                <div class="modal-body">
                                    <input type="hidden" name="user_id" value="<?= $user['iduser'] ?>">
                                    <div class="alert alert-danger">
                                        <i class="bi bi-exclamation-triangle"></i>
                                        <strong>Peringatan!</strong> Anda akan memadam pengguna ini secara kekal.
                                    </div>
                                    <p><strong>Username:</strong> <?= htmlspecialchars($user['username']) ?></p>
                                    <p><strong>Nama:</strong> <?= htmlspecialchars($user['realname']) ?></p>
                                    <p><strong>Peranan:</strong> <?= $user['peranan'] ?></p>
                                    <p class="text-danger">Tindakan ini tidak boleh dibatalkan!</p>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                                    <button type="submit" name="delete_user" class="btn btn-danger">Padam Pengguna</button>
                                </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Modal Tambah Pengguna -->
<div class="modal fade" id="addUserModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="post">
            <div class="modal-header">
                <h5 class="modal-title">Tambah Pengguna Baru</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="mb-3">
                    <label class="form-label">Username</label>
                    <input type="text" name="username" class="form-control" required>
                    <small class="text-muted">Username mesti unik</small>
                </div>
                <div class="mb-3">
                    <label class="form-label">Nama Sebenar</label>
                    <input type="text" name="realname" class="form-control" required>
                </div>
                <div class="mb-3">
                    <label class="form-label">Password</label>
                    <input type="password" name="password" class="form-control" required minlength="6">
                    <small class="text-muted">Minimum 6 aksara</small>
                </div>
                <div class="mb-3">
                    <label class="form-label">Peranan</label>
                    <select name="peranan" class="form-select" required>
                        <option value="">Pilih Peranan</option>
                        <option value="Admin">Admin</option>
                        <option value="Pengurus">Pengurus</option>
                        <option value="Pekerja">Pekerja</option>
                    </select>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Tutup</button>
                <button type="submit" name="add_user" class="btn btn-primary">Tambah Pengguna</button>
            </div>
            </form>
        </div>
    </div>
</div>

<?php include '../includes/footer.php'; ?> 