<?php
// Process form submissions BEFORE any output
if (isset($_POST['delete_image'])) {
    // Start session and connect to database
    session_start();
    include '../includes/db.php';

    // Check if user is Admin
    if ($_SESSION['user_peranan'] !== 'Admin') {
        header('Location: ../index.php');
        exit;
    }

    $image_type = $_POST['image_type'];
    $image_field = '';

    // Map image type to database field
    switch ($image_type) {
        case 'logo_image':
            $image_field = 'logo_image';
            break;
        case 'stamp_image':
            $image_field = 'stamp_image';
            break;
        case 'sign_image':
            $image_field = 'sign_image';
            break;
        default:
            header('Location: index.php?error=invalid_image_type');
            exit;
    }
    
    try {
        // Get current image filename
        $stmt = $conn->prepare("SELECT $image_field FROM shop_info WHERE id = 1");
        $stmt->execute();
        $result = $stmt->get_result();
        $row = $result->fetch_assoc();
        $current_image = $row[$image_field];
        
        // Delete file from uploads directory
        if (!empty($current_image)) {
            $file_path = '../uploads/' . $current_image;
            if (file_exists($file_path)) {
                unlink($file_path);
            }
        }
        
        // Update database to remove image reference
        $stmt = $conn->prepare("UPDATE shop_info SET $image_field = NULL WHERE id = 1");
    $stmt->execute();
    $stmt->close();
    
        // Success - redirect
        header('Location: index.php?image_deleted=1');
        exit;
        
    } catch (Exception $e) {
        // Log error
        error_log("Error in admin/index.php image delete: " . $e->getMessage());
        
        // Show error message instead of blank page
        $error_message = $e->getMessage();
    }
}

if (isset($_POST['update_shop_info'])) {
    // Start session and connect to database
    session_start();
    include '../includes/db.php';
    
    // Check if user is Admin
    if ($_SESSION['user_peranan'] !== 'Admin') {
        header('Location: ../index.php');
        exit;
    }
    
    // Get current shop info first
    $shop_query = "SELECT * FROM shop_info WHERE id = 1";
    $shop_result = $conn->query($shop_query);
    $shop = $shop_result->fetch_assoc();
    
    $shop_name = trim($_POST['shop_name']);
    $shop_address = trim($_POST['shop_address']);
    $shop_phone = trim($_POST['shop_phone']);
    $manager_name = trim($_POST['manager_name']);
    $bank_name = trim($_POST['bank_name']);
    $bank_account = trim($_POST['bank_account']);
    $bank_owner = trim($_POST['bank_owner']);
    
    try {
        // Handle logo upload
        $logo_image = $shop['logo_image'] ?? ''; // Keep existing logo by default
        
        if (isset($_FILES['logo_image']) && $_FILES['logo_image']['error'] === UPLOAD_ERR_OK) {
            $upload_dir = '../uploads/';
            $file_extension = strtolower(pathinfo($_FILES['logo_image']['name'], PATHINFO_EXTENSION));
            $allowed_extensions = ['jpg', 'jpeg', 'png'];
        
            if (in_array($file_extension, $allowed_extensions)) {
                $new_filename = 'logo_' . time() . '.' . $file_extension;
                $upload_path = $upload_dir . $new_filename;
                
                if (move_uploaded_file($_FILES['logo_image']['tmp_name'], $upload_path)) {
                    $logo_image = $new_filename;
            }
        }
    }
    
        // Handle stamp image upload
        $stamp_image = $shop['stamp_image'] ?? ''; // Keep existing stamp by default
        
        if (isset($_FILES['stamp_image']) && $_FILES['stamp_image']['error'] === UPLOAD_ERR_OK) {
            $upload_dir = '../uploads/';
            $file_extension = strtolower(pathinfo($_FILES['stamp_image']['name'], PATHINFO_EXTENSION));
            $allowed_extensions = ['jpg', 'jpeg', 'png'];
        
            if (in_array($file_extension, $allowed_extensions)) {
                $new_filename = 'stamp_' . time() . '.' . $file_extension;
                $upload_path = $upload_dir . $new_filename;
                
                if (move_uploaded_file($_FILES['stamp_image']['tmp_name'], $upload_path)) {
                    $stamp_image = $new_filename;
            }
        }
    }
    
        // Handle signature image upload
        $signature_image = $shop['sign_image'] ?? ''; // Keep existing signature by default
        
        if (isset($_FILES['signature_image']) && $_FILES['signature_image']['error'] === UPLOAD_ERR_OK) {
            $upload_dir = '../uploads/';
            $file_extension = strtolower(pathinfo($_FILES['signature_image']['name'], PATHINFO_EXTENSION));
            $allowed_extensions = ['jpg', 'jpeg', 'png'];
        
            if (in_array($file_extension, $allowed_extensions)) {
                $new_filename = 'signature_' . time() . '.' . $file_extension;
                $upload_path = $upload_dir . $new_filename;
                
                if (move_uploaded_file($_FILES['signature_image']['tmp_name'], $upload_path)) {
                    $signature_image = $new_filename;
                }
            }
        }
        
        $stmt = $conn->prepare("UPDATE shop_info SET shop_name=?, shop_address=?, shop_phone=?, manager_name=?, bank_name=?, bank_account=?, bank_owner=?, logo_image=?, stamp_image=?, sign_image=? WHERE id=1");
        $stmt->bind_param('ssssssssss', $shop_name, $shop_address, $shop_phone, $manager_name, $bank_name, $bank_account, $bank_owner, $logo_image, $stamp_image, $signature_image);
        $stmt->execute();
        $stmt->close();
        
        // Success - redirect
        header('Location: index.php?shop_updated=1');
        exit;
        
    } catch (Exception $e) {
        // Log error
        error_log("Error in admin/index.php shop update: " . $e->getMessage());
        
        // Show error message instead of blank page
        $error_message = $e->getMessage();
    }
}

if (isset($_POST['update_prices'])) {
    // Start session and connect to database
    session_start();
    include '../includes/db.php';
    
    // Check if user is Admin
    if ($_SESSION['user_peranan'] !== 'Admin') {
        header('Location: ../index.php');
    exit;
}

    $prices = $_POST['prices'];
    
    try {
        foreach ($prices as $item_type => $price_data) {
            $sale_price = (float)$price_data['sale_price'];
            $purchase_price = (float)$price_data['purchase_price'];
            
            $stmt = $conn->prepare("UPDATE prices SET sale_price=?, purchase_price=? WHERE item_type=?");
            $stmt->bind_param('dds', $sale_price, $purchase_price, $item_type);
            $stmt->execute();
            $stmt->close();
        }
        
        // Success - redirect
        header('Location: index.php?prices_updated=1');
    exit;
        
    } catch (Exception $e) {
        // Log error
        error_log("Error in admin/index.php prices update: " . $e->getMessage());
        
        // Show error message instead of blank page
        $error_message = $e->getMessage();
    }
}

// Set page variables for header
$page_title = 'Dashboard Admin';
$page_subtitle = 'Panel Admin';
$current_page = 'dashboard';
$base_path = '';

// Include header (includes session_start, db connection, and shop info)
include '../includes/header.php';

// Check if user is Admin
if ($_SESSION['user_peranan'] !== 'Admin') {
    header('Location: ../index.php');
    exit;
}


// Get current prices
$prices = [];
$price_result = $conn->query("SELECT * FROM prices");
while ($row = $price_result->fetch_assoc()) {
    $prices[$row['item_type']] = $row;
}
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2"><i class="bi bi-house-door"></i> Dashboard Admin</h1>
    <a href="../index.php" class="btn btn-secondary btn-modern">
        <i class="bi bi-arrow-left"></i> Kembali ke Senarai
    </a>
        </div>
        
<?php if (isset($_GET['shop_updated'])): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <i class="bi bi-check-circle"></i> Maklumat kedai berjaya dikemaskini!
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

<?php if (isset($_GET['prices_updated'])): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <i class="bi bi-check-circle"></i> Harga berjaya dikemaskini!
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

<?php if (isset($_GET['image_deleted'])): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <i class="bi bi-check-circle"></i> Gambar berjaya dipadam!
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

<?php if (isset($error_message)): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="bi bi-exclamation-triangle"></i> <?= htmlspecialchars($error_message) ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

            <div class="row">
                <!-- Maklumat Kedai -->
    <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0"><i class="bi bi-shop"></i> Maklumat Kedai</h5>
                        </div>
                        <div class="card-body">
                            <form method="post" enctype="multipart/form-data">
                                <div class="mb-3">
                                    <label class="form-label">Nama Kedai</label>
                                    <input type="text" name="shop_name" class="form-control" value="<?= htmlspecialchars($shop['shop_name']) ?>" required>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Alamat Kedai</label>
                                    <textarea name="shop_address" class="form-control" rows="3" required><?= htmlspecialchars($shop['shop_address']) ?></textarea>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">No Tel Kedai</label>
                                    <input type="text" name="shop_phone" class="form-control" value="<?= htmlspecialchars($shop['shop_phone']) ?>" required>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Nama Pengurus</label>
                                    <input type="text" name="manager_name" class="form-control" value="<?= htmlspecialchars($shop['manager_name']) ?>" required>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Nama Bank</label>
                                    <input type="text" name="bank_name" class="form-control" value="<?= htmlspecialchars($shop['bank_name']) ?>" required>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">No Akaun Bank</label>
                                    <input type="text" name="bank_account" class="form-control" value="<?= htmlspecialchars($shop['bank_account']) ?>" required>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Nama Pemilik Bank</label>
                                    <input type="text" name="bank_owner" class="form-control" value="<?= htmlspecialchars($shop['bank_owner']) ?>" required>
                                </div>
                                <div class="mb-3">
                        <label class="form-label">Logo Kedai</label>
                        <?php if (!empty($shop['logo_image']) && $shop['logo_image'] !== null): ?>
                            <div class="mb-2">
                                <img src="/eoderalh/uploads/<?= htmlspecialchars($shop['logo_image']) ?>" alt="Logo Kedai" class="img-thumbnail" style="max-width: 200px; max-height: 100px;" onerror="this.style.display='none'; this.nextElementSibling.style.display='block';">
                                <div class="mt-1">
                                    <button type="button" class="btn btn-danger btn-sm" onclick="deleteImage('logo_image')">
                                        <i class="bi bi-trash"></i> Padam Logo
                                    </button>
                                </div>
                                <div class="mt-1" style="display: none;">
                                    <small class="text-danger">Fail gambar tidak ditemui</small>
                                </div>
                                        </div>
                                    <?php else: ?>
                            <div class="mb-2">
                                <small class="text-muted">Tiada logo dipilih</small>
                            </div>
                        <?php endif; ?>
                        <input type="file" name="logo_image" class="form-control" accept="image/*">
                        <small class="text-muted">(jpg/png, biar kosong jika tak ubah)</small>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Gambar Cop</label>
                        <?php if (!empty($shop['stamp_image']) && $shop['stamp_image'] !== null): ?>
                            <div class="mb-2">
                                <img src="/eoderalh/uploads/<?= htmlspecialchars($shop['stamp_image']) ?>" alt="Gambar Cop" class="img-thumbnail" style="max-width: 150px; max-height: 100px;" onerror="this.style.display='none'; this.nextElementSibling.style.display='block';">
                                <div class="mt-1">
                                    <button type="button" class="btn btn-danger btn-sm" onclick="deleteImage('stamp_image')">
                                        <i class="bi bi-trash"></i> Padam Cop
                                    </button>
                                </div>
                                <div class="mt-1" style="display: none;">
                                    <small class="text-danger">Fail gambar tidak ditemui</small>
                                </div>
                                        </div>
                                    <?php else: ?>
                            <div class="mb-2">
                                <small class="text-muted">Tiada gambar cop dipilih</small>
                            </div>
                        <?php endif; ?>
                        <input type="file" name="stamp_image" class="form-control" accept="image/*">
                        <small class="text-muted">(jpg/png, biar kosong jika tak ubah)</small>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Gambar Tandatangan</label>
                        <?php if (!empty($shop['sign_image']) && $shop['sign_image'] !== null): ?>
                            <div class="mb-2">
                                <img src="/eoderalh/uploads/<?= htmlspecialchars($shop['sign_image']) ?>" alt="Gambar Tandatangan" class="img-thumbnail" style="max-width: 200px; max-height: 100px;" onerror="this.style.display='none'; this.nextElementSibling.style.display='block';">
                                <div class="mt-1">
                                    <button type="button" class="btn btn-danger btn-sm" onclick="deleteImage('sign_image')">
                                        <i class="bi bi-trash"></i> Padam Tandatangan
                                    </button>
                                </div>
                                <div class="mt-1" style="display: none;">
                                    <small class="text-danger">Fail gambar tidak ditemui</small>
                                </div>
                            </div>
                        <?php else: ?>
                            <div class="mb-2">
                                <small class="text-muted">Tiada gambar tandatangan dipilih</small>
                            </div>
                        <?php endif; ?>
                        <input type="file" name="signature_image" class="form-control" accept="image/*">
                        <small class="text-muted">(jpg/png, biar kosong jika tak ubah)</small>
                                </div>
                                
                    <button type="submit" name="update_shop_info" class="btn btn-primary btn-modern">
                                    <i class="bi bi-save"></i> Simpan Maklumat Kedai
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
                
    <!-- Harga Jualan & Belian -->
    <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0"><i class="bi bi-currency-dollar"></i> Harga Jualan & Belian</h5>
                        </div>
                        <div class="card-body">
                            <form method="post">
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead class="table-dark">
                                <tr>
                                    <th>Item</th>
                                    <th>Harga Jualan (RM)</th>
                                    <th>Harga Belian (RM)</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($prices as $item_type => $price): ?>
                                <tr>
                                    <td>
                                        <strong><?= ucfirst(str_replace('_', ' ', $item_type)) ?></strong>
                                    </td>
                                    <td>
                                        <input type="number" step="0.01" name="prices[<?= $item_type ?>][sale_price]" 
                                               class="form-control form-control-sm" 
                                               value="<?= $price['sale_price'] ?>" required>
                                    </td>
                                    <td>
                                        <input type="number" step="0.01" name="prices[<?= $item_type ?>][purchase_price]" 
                                               class="form-control form-control-sm" 
                                               value="<?= $price['purchase_price'] ?>" required>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    
                                <button type="submit" name="update_prices" class="btn btn-success btn-modern">
                                    <i class="bi bi-save"></i> Simpan Harga
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

<?php include '../includes/footer.php'; ?>

<script>
function deleteImage(imageType) {
    if (confirm('Adakah anda pasti mahu padam gambar ini?')) {
        // Create a form and submit it
        const form = document.createElement('form');
        form.method = 'POST';
        form.action = '';
        
        const input = document.createElement('input');
        input.type = 'hidden';
        input.name = 'image_type';
        input.value = imageType;
        
        const submitInput = document.createElement('input');
        submitInput.type = 'hidden';
        submitInput.name = 'delete_image';
        submitInput.value = '1';
        
        form.appendChild(input);
        form.appendChild(submitInput);
        document.body.appendChild(form);
        form.submit();
    }
}
</script> 