<?php
// Set page variables for header
$page_title = 'Analisis';
$page_subtitle = 'Analisis';
$current_page = 'analisis';
$base_path = '';

// Include header (includes session_start, db connection, and shop info)
include '../includes/header.php';

// Check if user is Admin
if ($_SESSION['user_peranan'] !== 'Admin') {
    header('Location: ../index.php');
    exit;
}

// Get filter parameters
$year = isset($_GET['year']) ? $_GET['year'] : date('Y');
$month = isset($_GET['month']) ? $_GET['month'] : 'all';

// Build date filter
$date_filter = "";
if ($month !== 'all') {
    $date_filter = "WHERE YEAR(order_date) = $year AND MONTH(order_date) = $month";
} else {
    $date_filter = "WHERE YEAR(order_date) = $year";
}

// Get summary data
$summary_query = "SELECT 
    SUM(total_sale) as total_sales,
    SUM(total_cost_price) as total_cost,
    SUM(total_sale - total_cost_price) as total_profit
FROM orders $date_filter";
$summary_result = $conn->query($summary_query);
$summary = $summary_result->fetch_assoc();

// Get payment analysis
$payment_query = "SELECT 
    SUM(CASE WHEN status_bayar = 'Sudah' THEN total_sale ELSE 0 END) as paid_amount,
    COUNT(CASE WHEN status_bayar = 'Sudah' THEN 1 END) as paid_count,
    SUM(CASE WHEN status_bayar = 'Belum' THEN total_sale ELSE 0 END) as unpaid_amount,
    COUNT(CASE WHEN status_bayar = 'Belum' THEN 1 END) as unpaid_count
FROM orders $date_filter";
$payment_result = $conn->query($payment_query);
$payment = $payment_result->fetch_assoc();

// Get order status analysis
$status_query = "SELECT 
    COUNT(CASE WHEN status_order = 'Baru' THEN 1 END) as new_orders,
    COUNT(CASE WHEN status_order = 'Dalam Proses' THEN 1 END) as in_progress_orders,
    COUNT(CASE WHEN status_order = 'Siap' AND status_hantar = 'Belum' THEN 1 END) as ready_not_shipped,
    COUNT(CASE WHEN status_order = 'Siap' AND status_hantar = 'Sudah' AND status_bayar = 'Belum' THEN 1 END) as ready_shipped_unpaid,
    SUM(CASE WHEN status_order = 'Siap' AND status_hantar = 'Sudah' AND status_bayar = 'Belum' THEN total_sale ELSE 0 END) as ready_shipped_unpaid_amount
FROM orders $date_filter";
$status_result = $conn->query($status_query);
$status = $status_result->fetch_assoc();

// Get detailed analysis
$detailed_query = "SELECT 
    id,
    customer_name,
    order_date,
    total_sale,
    total_cost_price,
    (total_sale - total_cost_price) as profit,
    status_order,
    status_hantar,
    status_bayar,
    ROUND(((total_sale - total_cost_price) / total_sale) * 100, 1) as margin_percent
FROM orders $date_filter
ORDER BY order_date DESC";
$detailed_result = $conn->query($detailed_query);

// Get unique years for filter
$years_query = "SELECT DISTINCT YEAR(order_date) as year FROM orders ORDER BY year DESC";
$years_result = $conn->query($years_query);
$years = [];
while ($row = $years_result->fetch_assoc()) {
    $years[] = $row['year'];
}
?>

<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2"><i class="bi bi-graph-up"></i> Analisis Jualan, Kos & Untung</h1>
    <div class="d-flex gap-2 align-items-center">
        <div class="d-flex gap-2">
            <select class="form-select form-select-sm" style="width: auto; min-width: 80px;" onchange="updateFilter()" id="yearFilter">
                <?php foreach ($years as $y): ?>
                    <option value="<?= $y ?>" <?= $y == $year ? 'selected' : '' ?>><?= $y ?></option>
                <?php endforeach; ?>
            </select>
            <select class="form-select form-select-sm" style="width: auto; min-width: 120px;" onchange="updateFilter()" id="monthFilter">
                <option value="all" <?= $month == 'all' ? 'selected' : '' ?>>Semua Bulan</option>
                <option value="1" <?= $month == '1' ? 'selected' : '' ?>>Januari</option>
                <option value="2" <?= $month == '2' ? 'selected' : '' ?>>Februari</option>
                <option value="3" <?= $month == '3' ? 'selected' : '' ?>>Mac</option>
                <option value="4" <?= $month == '4' ? 'selected' : '' ?>>April</option>
                <option value="5" <?= $month == '5' ? 'selected' : '' ?>>Mei</option>
                <option value="6" <?= $month == '6' ? 'selected' : '' ?>>Jun</option>
                <option value="7" <?= $month == '7' ? 'selected' : '' ?>>Julai</option>
                <option value="8" <?= $month == '8' ? 'selected' : '' ?>>Ogos</option>
                <option value="9" <?= $month == '9' ? 'selected' : '' ?>>September</option>
                <option value="10" <?= $month == '10' ? 'selected' : '' ?>>Oktober</option>
                <option value="11" <?= $month == '11' ? 'selected' : '' ?>>November</option>
                <option value="12" <?= $month == '12' ? 'selected' : '' ?>>Disember</option>
            </select>
        </div>
    </div>
</div>

<!-- Summary Cards -->
<div class="row mb-4">
    <div class="col-md-4">
        <div class="card bg-primary text-white">
            <div class="card-body text-center">
                <h4 class="card-title">Jumlah Jualan</h4>
                <h2 class="mb-0">RM <?= number_format($summary['total_sales'] ?? 0, 2) ?></h2>
            </div>
        </div>
                </div>
    <div class="col-md-4">
        <div class="card bg-warning text-white">
            <div class="card-body text-center">
                <h4 class="card-title">Jumlah Kos</h4>
                <h2 class="mb-0">RM <?= number_format($summary['total_cost'] ?? 0, 2) ?></h2>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card bg-success text-white">
            <div class="card-body text-center">
                <h4 class="card-title">Jumlah Untung</h4>
                <h2 class="mb-0">RM <?= number_format($summary['total_profit'] ?? 0, 2) ?></h2>
            </div>
        </div>
                </div>
                </div>
            
<!-- Payment and Status Analysis -->
            <div class="row mb-4">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><i class="bi bi-credit-card"></i> Analisis Pembayaran</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-6">
                        <div class="text-center">
                            <h3 class="text-success"><?= $payment['paid_count'] ?? 0 ?></h3>
                            <p class="mb-1">Sudah Bayar</p>
                            <small class="text-muted">RM <?= number_format($payment['paid_amount'] ?? 0, 2) ?></small>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="text-center">
                            <h3 class="text-danger"><?= $payment['unpaid_count'] ?? 0 ?></h3>
                            <p class="mb-1">Belum Bayar</p>
                            <small class="text-muted">RM <?= number_format($payment['unpaid_amount'] ?? 0, 2) ?></small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0"><i class="bi bi-list-check"></i> Analisis Status Order</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-4">
                        <div class="text-center">
                            <h3 class="text-secondary"><?= $status['new_orders'] ?? 0 ?></h3>
                            <p class="mb-1">Order Baru</p>
                        </div>
                    </div>
                    <div class="col-4">
                        <div class="text-center">
                            <h3 class="text-info"><?= $status['ready_not_shipped'] ?? 0 ?></h3>
                            <p class="mb-1">Order Siap (Belum Hantar)</p>
                    </div>
                </div>
                    <div class="col-4">
                        <div class="text-center">
                            <h3 class="text-warning"><?= $status['ready_shipped_unpaid'] ?? 0 ?></h3>
                            <p class="mb-1">Belum Bayar (Siap & Hantar)</p>
                            <small class="text-muted">RM <?= number_format($status['ready_shipped_unpaid_amount'] ?? 0, 2) ?></small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Sales by User Analysis -->
<div class="card mb-4">
    <div class="card-header">
        <h5 class="mb-0"><i class="bi bi-people"></i> Analisis Jualan Mengikut Pengguna</h5>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead class="table-dark">
                    <tr>
                        <th>Bil</th>
                        <th>Nama Pengguna</th>
                        <th>Peranan</th>
                        <th class="text-end">Jumlah Order</th>
                        <th class="text-end">Jumlah Jualan (RM)</th>
                        <th class="text-end">Jumlah Kos (RM)</th>
                        <th class="text-end">Jumlah Untung (RM)</th>
                        <th class="text-end">Purata Jualan (RM)</th>
                        <th class="text-end">Margin (%)</th>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                    // Get sales by user
                    $user_sales_query = "SELECT 
                        u.realname,
                        u.peranan,
                        COUNT(o.id) as total_orders,
                        SUM(o.total_sale) as total_sales,
                        SUM(o.total_cost_price) as total_cost,
                        SUM(o.total_sale - o.total_cost_price) as total_profit,
                        AVG(o.total_sale) as avg_sale,
                        CASE 
                            WHEN SUM(o.total_sale) > 0 THEN ROUND(((SUM(o.total_sale - o.total_cost_price) / SUM(o.total_sale)) * 100), 1)
                            ELSE 0 
                        END as margin_percent
                    FROM users u
                    LEFT JOIN orders o ON u.iduser = o.user_id $where_clause
                    GROUP BY u.iduser, u.realname, u.peranan
                    ORDER BY total_sales DESC";
                    
                    $user_sales_result = $conn->query($user_sales_query);
                    $i = 1;
                    while ($user = $user_sales_result->fetch_assoc()):
                    ?>
                    <tr>
                        <td><?= $i++ ?></td>
                        <td><?= htmlspecialchars($user['realname']) ?></td>
                        <td>
                            <span class="badge bg-<?= $user['peranan'] === 'Admin' ? 'danger' : ($user['peranan'] === 'Pengurus' ? 'warning' : 'success') ?>">
                                <?= $user['peranan'] ?>
                            </span>
                        </td>
                        <td class="text-end"><?= $user['total_orders'] ?? 0 ?></td>
                        <td class="text-end"><?= number_format($user['total_sales'] ?? 0, 2) ?></td>
                        <td class="text-end"><?= number_format($user['total_cost'] ?? 0, 2) ?></td>
                        <td class="text-end">
                            <span class="badge bg-<?= ($user['total_profit'] ?? 0) >= 0 ? 'success' : 'danger' ?>">
                                <?= number_format($user['total_profit'] ?? 0, 2) ?>
                            </span>
                        </td>
                        <td class="text-end"><?= number_format($user['avg_sale'] ?? 0, 2) ?></td>
                        <td class="text-end">
                            <span class="badge bg-<?= ($user['margin_percent'] ?? 0) >= 0 ? 'success' : 'danger' ?>">
                                <?= $user['margin_percent'] ?? 0 ?>%
                            </span>
                        </td>
                    </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
                    </div>
                </div>
            </div>
            
<!-- Detailed Analysis Table -->
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0"><i class="bi bi-table"></i> Analisis Terperinci Setiap Tempahan</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
            <table class="table table-hover">
                <thead class="table-dark">
                                <tr>
                                    <th>Bil</th>
                                    <th>Nama Pelanggan</th>
                                    <th>Tarikh Order</th>
                        <th class="text-end">Jualan (RM)</th>
                        <th class="text-end">Kos (RM)</th>
                        <th class="text-end">Untung (RM)</th>
                        <th>Status Order</th>
                        <th>Penghantaran</th>
                        <th>Pembayaran</th>
                        <th class="text-end">Margin (%)</th>
                                </tr>
                            </thead>
                            <tbody>
                    <?php $i = 1; while ($row = $detailed_result->fetch_assoc()): ?>
                                <tr>
                                    <td><?= $i++ ?></td>
                        <td><?= htmlspecialchars($row['customer_name']) ?></td>
                        <td><?= date('d/m/Y', strtotime($row['order_date'])) ?></td>
                        <td class="text-end"><?= number_format($row['total_sale'], 2) ?></td>
                        <td class="text-end"><?= number_format($row['total_cost_price'], 2) ?></td>
                                    <td class="text-end">
                            <span class="badge bg-<?= $row['profit'] >= 0 ? 'success' : 'danger' ?>">
                                <?= number_format($row['profit'], 2) ?>
                            </span>
                        </td>
                        <td>
                            <span class="badge bg-<?= $row['status_order'] == 'Siap' ? 'success' : ($row['status_order'] == 'Batal' ? 'danger' : ($row['status_order'] == 'Dalam Proses' ? 'warning' : 'secondary')) ?>">
                                <?= $row['status_order'] ?>
                            </span>
                        </td>
                        <td>
                            <span class="badge bg-<?= $row['status_hantar'] == 'Sudah' ? 'info' : 'secondary' ?>">
                                <?= $row['status_hantar'] ?>
                                        </span>
                                    </td>
                                    <td>
                            <span class="badge bg-<?= $row['status_bayar'] == 'Sudah' ? 'primary' : 'secondary' ?>">
                                <?= $row['status_bayar'] ?>
                                        </span>
                                    </td>
                                    <td class="text-end">
                            <span class="badge bg-<?= $row['margin_percent'] >= 0 ? 'success' : 'danger' ?>">
                                <?= $row['margin_percent'] ?>%
                                        </span>
                                    </td>
                                </tr>
                    <?php endwhile; ?>
                            </tbody>
                            <tfoot class="table-dark">
                                <tr>
                                    <th colspan="3">JUMLAH KESELURUHAN</th>
                        <th class="text-end">RM <?= number_format($summary['total_sales'] ?? 0, 2) ?></th>
                        <th class="text-end">RM <?= number_format($summary['total_cost'] ?? 0, 2) ?></th>
                        <th class="text-end">RM <?= number_format($summary['total_profit'] ?? 0, 2) ?></th>
                        <th colspan="3"></th>
                                    <th class="text-end">
                                        <?php 
                            $total_margin = $summary['total_sales'] > 0 ? 
                                (($summary['total_profit'] / $summary['total_sales']) * 100) : 0;
                                        ?>
                            <span class="badge bg-<?= $total_margin >= 0 ? 'success' : 'danger' ?>">
                                <?= round($total_margin, 1) ?>%
                                        </span>
                                    </th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>

<script>
function updateFilter() {
    const year = document.getElementById('yearFilter').value;
    const month = document.getElementById('monthFilter').value;
    window.location.href = `analisis.php?year=${year}&month=${month}`;
}
</script>

<?php include '../includes/footer.php'; ?> 